# NanoCERN CLI - Headless Knowledge Reactor

**Minimal constraint-based reasoning engine**

## What is NanoCERN?

A deterministic reasoning system that encodes domain knowledge as **atomic constraints** (Knowledge Units). Every decision is explainable and traceable.

## Quick Start

```bash
# Install
pip install -e .

# List all Knowledge Units
nanocern list

# Check constraint
nanocern check atoms/MED-METFORMIN-RENAL.ku --state '{"GFR": 25}'

# Validate KU
nanocern validate atoms/MED-METFORMIN-RENAL.ku
```

## Knowledge Unit Structure

```json
{
  "id": "MED-METFORMIN-RENAL",
  "domain": "medicine",
  "invariant": "Metformin contraindicated when GFR < 30 mL/min",
  "applies_if": {"GFR": "< 30"},
  "failure_modes": ["lactic_acidosis"],
  "metadata": {"source": "FDA", "confidence": 1.0}
}
```

## CLI Commands

### List KUs
```bash
nanocern list
```

### Check Constraint
```bash
nanocern check atoms/MED-METFORMIN-RENAL.ku --state '{"GFR": 25, "age": 75}'
```

### Validate KU
```bash
nanocern validate atoms/PHY-RS1-WARPED-GRAVITY-1999.ku
```

## Python API

```python
from nanocern import load_ku, check_constraint

ku = load_ku('atoms/MED-METFORMIN-RENAL.ku')
state = {"GFR": 25}
violations = check_constraint(ku, state)
```

## Included KUs

- **Medicine**: 90+ drug safety constraints
- **Physics**: RS1 warped gravity, particle physics
- **Chemistry**: Reaction boundaries
- **Math**: Theorem constraints

## Why Constraint-Based?

**Traditional ML**: Black box → confidence score  
**NanoCERN**: Explicit constraints → explainable reasoning

## License

MIT - See LICENSE file

---

*Built with 🥔 power*
