"""
Organ state machines for complete physiological model.

Each organ module defines:
- Basal state (normal physiology)
- State variables (numerical parameters)
- State transitions (disease states)
- Inter-organ connections (effects on other organs)
"""

from .base_organ import OrganState
from .heart import HeartState
from .lungs import LungState
from .liver import LiverState
from .kidneys import KidneyState
from .brain import BrainState
from .pancreas import PancreasState
from .gut import GutState
from .immune_system import ImmuneState
from .endocrine import EndocrineState
from .muscles import MuscleState
from .bones import BoneState
from .skin import SkinState

__all__ = [
    'OrganState',
    'HeartState',
    'LungState',
    'LiverState',
    'KidneyState',
    'BrainState',
    'PancreasState',
    'GutState',
    'ImmuneState',
    'EndocrineState',
    'MuscleState',
    'BoneState',
    'SkinState'
]
