# Installation Guide

## System Requirements

- **Operating System**: Linux, macOS, or Windows
- **Python**: 3.10 or higher
- **RAM**: 4GB minimum, 8GB recommended
- **Disk Space**: 500MB

## Installation Steps

### 1. Extract Package

```bash
unzip medical_research_package.zip
cd medical_research_package
```

### 2. Create Virtual Environment (Recommended)

```bash
python3 -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate
```

### 3. Install Dependencies

```bash
pip install -r requirements.txt
```

### 4. Verify Installation

```bash
python -c "from body_model.body_state_model import HumanBodyState; print('✅ Success!')"
```

## Troubleshooting

### Import Errors

If you get import errors, ensure you're in the package directory:

```bash
cd medical_research_package
export PYTHONPATH="${PYTHONPATH}:$(pwd)"
```

### Python Version

Check your Python version:

```bash
python --version  # Should be 3.10+
```

## Next Steps

- Read README.md for overview
- Run examples: `python examples/demo_scenarios.py`
- Explore docs/ for detailed documentation
